/*
 * Copyright (C) 2012 Edge-Core Networks
 * This software file (the "File") is owned and distributed by 
 * Edge-Core Networks under the following licensing terms.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef _AMS_PART_H_
#define _AMS_PART_H_

 

#define FLASH_REGION_NAMELEN        64
#define PART_FILE_NAMELEN           32
#define DEVICE_NAMELEN              64
#define MAX_PARTITION_NUMBER	    16
#define PARTITION_TABLE_MAGIC       0x646c7470
#define PARTITION_VERSION           0x1
#define PARTITION_TYPE_LEN          16
#define CF_STANDARD_SECTOR_SIZE		512
#define AMS_BPB_SIGNATURE           0x55AAAA55

 
/* partition mode */
#define PART_MODE_RO    0x00        /* Read Only */
#define PART_MODE_RW    0x01        /* Read + Write */


/* 2009/08, aaron, force size of enum to 4 bytes
 * because not all of compiler can take enum to be the same size.
 */
typedef unsigned long AMS_PARTITION_TYPE_T;
typedef unsigned long AMS_FILEMAPPING_PART_TYPE_T;
typedef unsigned long AMS_FILEMAPPING_PARTITION_STATUS_T;
typedef unsigned long AMS_PARTITION_DEVICE_TYPE_T;


 /*
  *  Partition table structure define, also used as file type
  */
enum
{
    TYPE_NOT_USED,              /* partition not used */
    TYPE_BOOTLOADER,            /* bootloader */
    TYPE_KERNEL,                /* kernel image */
    TYPE_RUNTIME,               /* runtime Image */
    TYPE_ENV,                   /* u-boot env parames */
    TYPE_ROOT_FS,               /* root file system */
    TYPE_PARTITION_TABLE,       /* partition table management */
    TYPE_FILEMAPPING_TABLE,     /* filemapping management */
    TYPE_USERDATA,              /* user data */
    TYPE_HWINFO,                /* hardware information */
    TYPE_FS,                    /* filesystem management:ext2 */
    TYPE_BACKUP_BOOT_RECORD,    /* for backup critical data, partition table, etc. */
    TYPE_MAX                    /* type end*/
};  /* AMS_PARTITION_TYPE_T */

 /*
  *  Partition device type define
  */
enum
{
	TYPE_DEVICE_NO_USED,
	TYPE_DEVICE_NOR,
	TYPE_DEVICE_NAND,
	TYPE_DEVICE_CFCARD,
	TYPE_DEVICE_SPI,             /* 2009/07/22, aaron, add new flash device (SPI flash) in AMS */
	TYPE_DEVICE_MAX
}; /* AMS_PARTITION_DEVICE_TYPE_T */

 /*
  *  filemapping partition type define
  */
enum
{
    PART_TYPE_NO_USED,
    PART_TYPE_FIXED,
    PART_TYPE_FILESYSTEM
}; /* AMS_FILEMAPPING_PART_TYPE_T */

 /*
  *  filemapping partition status define
  */
enum
{
    AMS_PARTITION_FREE = 1,
    AMS_PARTITION_ACTIVE = 2,
    AMS_PARTITION_INACTIVE = 4,
}; /* AMS_FILEMAPPING_PARTITION_STATUS_T */


 /*
  *  Partition Table Management struct define
  */

typedef struct FlashRegion {
    unsigned char  region_name[FLASH_REGION_NAMELEN];
    unsigned long  region_base;
    unsigned long  region_size;
    unsigned long  region_type;                 /* indicate partition type */
    unsigned long  region_mode;                 /* region mode, R/W */                
    unsigned long  region_reserved[7];          /* reserved 28 bytes */     
    unsigned char  device_name[DEVICE_NAMELEN];
    unsigned long  region_checksum;
} FlashRegion_T;

/*
 *  Flash Partition Table type
 */
typedef struct PartitionTable {
    unsigned long magic; 	          /* BOOTLDR_PARTITION_MAGIC should be filled with 0x646c7470 (btlp) */
    unsigned long version;			  /* version number   */
    unsigned long reserved[2];		  /* reserved 8 bytes */
    unsigned long header_checksum;    /* checksum of header in this data structure */
    struct FlashRegion flash_region[MAX_PARTITION_NUMBER];
} AMS_PARTITION_TABLE_T;



/*
 *  FileMapping Management type
 */
#if 0
typedef struct FileMapping{                  
    unsigned char file_name[PART_FILE_NAMELEN]; /* filename in partition */
    unsigned long file_size;                    /* file size */
    unsigned long creat_time;                   /* file create time */
    unsigned long part_index;                   /* file-saved partition index */
    AMS_PARTITION_TYPE_T               file_type;       /* file type */
    AMS_FILEMAPPING_PART_TYPE_T        part_type;       /* file-saved partition type */
    AMS_FILEMAPPING_PARTITION_STATUS_T startup_flag;    /* start-up flag  indicate partition status is active or free */
    unsigned long reserved[40];                         /* reserved 160 bytes for runtime use */
    unsigned long part_checksum;                /* checksum of this data structure */
}AMS_FILEMAPPING_T;
#endif
//direct copy from FS_FILEMAPPING_FILE_DATA_T
#if 0
typedef struct {
    UI8_T          file_name[SYS_ADPT_FILE_SYSTEM_NAME_LEN]; /* filename */
    UI32_T         file_size;                                /* file size */
    UI32_T         creat_time;                               /* file create time */
    FS_File_Type_T file_type;                                /* file type */
    BOOL_T         startup_flag;                             /* start-up flag  indicate status is active or free */
}FS_FILEMAPPING_FILE_DATA_T;
#endif
typedef struct FileMapping {
    unsigned char          file_name[SYS_ADPT_FILE_SYSTEM_NAME_LEN]; /* filename */
    unsigned long         file_size;                                /* file size */
    unsigned long         creat_time;                               /* file create time */
    AMS_PARTITION_TYPE_T file_type;                                /* file type */
    BOOL_T         startup_flag;                             /* start-up flag  indicate status is active or free */
}AMS_FILEMAPPING_T;

typedef struct FileMappingManage{
    struct FileMapping filemapping[MAX_PARTITION_NUMBER];
}AMS_FILEMAPPING_MGR_T;

typedef struct PartBootConfig {
    unsigned long  bootflags;
    unsigned long  reserve[64];
} AMS_PARTBOOTCONFIG_T;


/*
 * Boot Parameter Block type
 */
typedef struct BPB_S{
    unsigned long           signature;      /* Signature */
    unsigned long           length;         /* byte count of field except for checksum */
    AMS_PARTITION_TABLE_T   pat_table;      /* partition table */
    AMS_FILEMAPPING_MGR_T   file_map;       /* file mapping table */
    FS_HW_Info_T            hw_info;        /* hardware information */
    unsigned long           checksum;           
}AMS_BPB_T;
 
#endif  /* #_AMS_PART_H_ */

